<?php
$title = "Tasa (TASA.TXT)";
ob_start(); ?>
<div class="card">
  <div class="h1">Tasa (TASA.TXT)</div>
  <p class="small">Cargá la tasa por período en formato <b>EEE,DD</b> (ej: 125,50). Si no corresponde, dejá 000,00.</p>
</div>

<div class="card">
  <div class="h1">Cargar / actualizar tasa</div>
  <form method="post" action="index.php?r=rate_save">
    <div class="row">
      <div>
        <label>Período (YYYYMM)</label>
        <input name="period" value="<?= h(date('Ym')) ?>" required placeholder="202512">
      </div>
      <div>
        <label>Financiaciones sin garantía real otorgadas (0/1)</label>
        <select name="no_real_guarantee">
          <option value="0">0 - No</option>
          <option value="1">1 - Sí</option>
        </select>
      </div>
    </div>
    <div style="margin-top:12px">
      <label>Tasa promedio ponderada (EEE,DD)</label>
      <input name="weighted_rate" value="000,00" required placeholder="125,50" maxlength="6">
      <div class="small">Si campo 1=0, la tasa debe ser 000,00.</div>
    </div>
    <div style="display:flex; gap:10px; margin-top:14px">
      <button class="btn" type="submit">Guardar</button>
    </div>
  </form>
</div>

<div class="card">
  <div class="h1">Tasas cargadas</div>
  <table class="table">
    <thead><tr><th>Período</th><th>Campo 1</th><th>Tasa</th><th>Acciones</th></tr></thead>
    <tbody>
    <?php foreach($rates as $r): ?>
      <tr>
        <td><?= h($r['period']) ?></td>
        <td><?= (int)$r['no_real_guarantee'] ?></td>
        <td><span class="badge"><?= h($r['weighted_rate']) ?></span></td>
        <td style="white-space:nowrap">
          <a class="btn secondary" href="index.php?r=rate_edit&period=<?= h($r['period']) ?>">Editar</a>
          <a class="btn danger" data-confirm="¿Eliminar tasa?" href="index.php?r=rate_delete&period=<?= h($r['period']) ?>">Eliminar</a>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
  <?php if(count($rates)===0): ?><p class="small">Sin tasas cargadas.</p><?php endif; ?>
</div>

<?php
$content = ob_get_clean();
require __DIR__ . '/layout.php';
