<?php
$title = "Generar archivos";
ob_start(); ?>
<div class="card">
  <div class="h1">Generación de archivos</div>
  <form method="post" action="index.php?r=export_run">
    <div class="row">
      <div>
        <label>Período (YYYYMM)</label>
        <input name="period" value="<?= h(date('Ym')) ?>" required placeholder="202512">
        <div class="small">Se usarán los importes de ese período para calcular el Total de deuda.</div>
      </div>
      <div style="display:flex; align-items:end; gap:10px">
        <button class="btn" type="submit">Generar PROVEEDORES / IMPORTES / TASA</button>
      </div>
    </div>
  </form>
  <hr>
  <p class="small">Los archivos se generan en la carpeta <b>/exports</b> y se descargan desde acá.</p>
</div>

<?php if (!empty($generated)): ?>
  <div class="card">
    <div class="h1">Archivos generados</div>
    <ul>
      <?php foreach($generated as $g): ?>
        <li><a href="<?= h($g['url']) ?>"><?= h($g['name']) ?></a> <span class="small">(<?= h($g['size']) ?>)</span></li>
      <?php endforeach; ?>
    </ul>
  </div>
<?php endif; ?>

<div class="card">
  <div class="h1">Validaciones rápidas</div>
  <ul class="small">
    <li>Si no existen datos en ninguno de los archivos, en BCRA se presenta con opción “No opera”.</li>
    <li>Importes se exportan en miles de pesos y se excluyen deudores con total &lt; $25.000.</li>
    <li>Se controla que no haya duplicados (tipo+número) en PROVEEDORES y (tipo+número+asistencia) en IMPORTES.</li>
  </ul>
</div>
<?php
$content = ob_get_clean();
require __DIR__ . '/layout.php';
