<?php
$title = "Deudores";
ob_start(); ?>
<div class="card">
  <div class="h1">Deudores</div>
  <div style="display:flex; gap:10px; flex-wrap:wrap">
    <a class="btn" href="index.php?r=debtor_new">+ Nuevo deudor</a>
  </div>
</div>

<div class="card">
  <table class="table">
    <thead>
      <tr>
        <th>Identificación</th>
        <th>Denominación</th>
        <th>Situación</th>
        <th>Art.26</th>
        <th>Recat.</th>
        <th>Acciones</th>
      </tr>
    </thead>
    <tbody>
    <?php foreach ($debtors as $d): ?>
      <tr>
        <td><?= h($d['id_type']) ?> - <?= h($d['id_number']) ?></td>
        <td><?= h($d['name']) ?></td>
        <td><span class="badge"><?= h($d['situation_code']) ?></span></td>
        <td><?= (int)$d['art26_flag']===1 ? 'Sí' : 'No' ?></td>
        <td><?= (int)$d['recat_flag']===1 ? 'Sí' : 'No' ?></td>
        <td style="white-space:nowrap">
          <a class="btn secondary" href="index.php?r=debtor_edit&id=<?= (int)$d['id'] ?>">Editar</a>
          <a class="btn danger" data-confirm="¿Eliminar deudor?" href="index.php?r=debtor_delete&id=<?= (int)$d['id'] ?>">Eliminar</a>
        </td>
      </tr>
    <?php endforeach; ?>
    </tbody>
  </table>
  <?php if (count($debtors)===0): ?>
    <p class="small">Todavía no hay deudores cargados.</p>
  <?php endif; ?>
</div>
<?php
$content = ob_get_clean();
require __DIR__ . '/layout.php';
