<?php
$title = $mode === 'new' ? "Nuevo deudor" : "Editar deudor";
ob_start(); ?>
<div class="card">
  <div class="h1"><?= $mode==='new'?'Nuevo deudor':'Editar deudor' ?></div>
  <form method="post" action="index.php?r=debtor_save">
    <input type="hidden" name="id" value="<?= h((string)($debtor['id'] ?? '')) ?>">
    <div class="row">
      <div>
        <label>Tipo de identificación</label>
        <select name="id_type">
          <?php foreach ([11=>'11 (CUIT/CUIL/CDI)',98=>'98 (Exterior PJ sin CUIT)',99=>'99 (Exterior PH sin CUIT)'] as $k=>$v): ?>
            <option value="<?= $k ?>" <?= (int)($debtor['id_type']??11)===$k?'selected':'' ?>><?= h($v) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Número de identificación (máx 11)</label>
        <input name="id_number" maxlength="11" required value="<?= h($debtor['id_number'] ?? '') ?>" placeholder="Ej: 30716063786">
      </div>
    </div>

    <div style="margin-top:12px">
      <label>Denominación</label>
      <input name="name" maxlength="55" required value="<?= h($debtor['name'] ?? '') ?>" placeholder="Se exporta en MAYÚSCULAS sin tildes">
      <div class="small">No uses punto y coma (;). Se limpia automáticamente al exportar.</div>
    </div>

    <div class="row" style="margin-top:12px">
      <div>
        <label>Situación (código)</label>
        <select name="situation_code">
          <?php foreach (['01'=>'01 Normal','21'=>'21 Riesgo Bajo','03'=>'03 Riesgo Medio','04'=>'04 Riesgo Alto','05'=>'05 Irrecuperable'] as $k=>$v): ?>
            <option value="<?= h($k) ?>" <?= ($debtor['situation_code']??'01')===$k?'selected':'' ?>><?= h($v) ?></option>
          <?php endforeach; ?>
        </select>
      </div>
      <div>
        <label>Deudor encuadrado Art. 26 inc. 4 (Ley 25.326) (0/1)</label>
        <select name="art26_flag">
          <option value="0" <?= (int)($debtor['art26_flag']??0)===0?'selected':'' ?>>0 - No aplicable</option>
          <option value="1" <?= (int)($debtor['art26_flag']??0)===1?'selected':'' ?>>1 - Sí</option>
        </select>
      </div>
    </div>

    <div class="row" style="margin-top:12px">
      <div>
        <label>Recategorización obligatoria (0/1)</label>
        <select name="recat_flag">
          <option value="0" <?= (int)($debtor['recat_flag']??0)===0?'selected':'' ?>>0 - No</option>
          <option value="1" <?= (int)($debtor['recat_flag']??0)===1?'selected':'' ?>>1 - Sí</option>
        </select>
        <div class="small">Si es 0, días de atraso queda nulo y situación sin reclasificar debe ser 00.</div>
      </div>
      <div>
        <label>Días de atraso (solo si recat=1)</label>
        <input name="days_overdue" type="number" min="0" max="9999" value="<?= h((string)($debtor['days_overdue'] ?? '')) ?>" placeholder="Ej: 45">
      </div>
    </div>

    <div style="margin-top:12px">
      <label>Situación sin reclasificar (00 si recat=0)</label>
      <select name="situation_without_reclass">
        <?php foreach (['00'=>'00','01'=>'01','21'=>'21','03'=>'03','04'=>'04','05'=>'05'] as $k=>$v): ?>
          <option value="<?= h($k) ?>" <?= ($debtor['situation_without_reclass']??'00')===$k?'selected':'' ?>><?= h($v) ?></option>
        <?php endforeach; ?>
      </select>
    </div>

    <div style="display:flex; gap:10px; margin-top:14px">
      <button class="btn" type="submit">Guardar</button>
      <a class="btn secondary" href="index.php?r=debtors">Volver</a>
    </div>
  </form>
</div>
<?php
$content = ob_get_clean();
require __DIR__ . '/layout.php';
