<?php
declare(strict_types=1);

function db(): PDO {
  static $pdo = null;
  if ($pdo instanceof PDO) return $pdo;

  $cfg = require __DIR__ . '/config.php';
  $dbPath = $cfg['db_path'];
  $isNew = !file_exists($dbPath);

  if (!is_dir(dirname($dbPath))) {
    mkdir(dirname($dbPath), 0775, true);
  }

  $pdo = new PDO('sqlite:' . $dbPath, null, null, [
    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
  ]);
  $pdo->exec("PRAGMA foreign_keys = ON");

  if ($isNew) {
    $schema = file_get_contents(dirname(__DIR__) . '/sql/schema.sql');
    $pdo->exec($schema);
    $seed = file_get_contents(dirname(__DIR__) . '/sql/seed.sql');
    $pdo->exec($seed);
    // default settings
    $stmt = $pdo->prepare("INSERT OR IGNORE INTO settings(key,value) VALUES(:k,:v)");
    $stmt->execute([':k'=>'entity_code', ':v'=>'00000']); // opcional si luego querés usarlo para exterior 98/99
  }

  return $pdo;
}
