# BCRA - Deudores (Sección 59) - Web PHP + SQLite

Sistema simple para:
- Cargar deudores (actuales y futuros)
- Cargar asistencias (IMPORTES) por deudor
- Cargar TASA mensual
- Generar automáticamente los archivos:
  - PROVEEDORES.TXT
  - IMPORTES.TXT
  - TASA.TXT

## Requisitos
- PHP 8.0+ con extensión SQLite (pdo_sqlite) habilitada.
- Hosting cPanel / Apache o similar.

## Instalación
1) Subí todo el contenido de la carpeta `public/` a tu `public_html` (o al subdominio que uses).
   - Si preferís subir todo el proyecto, apuntá el DocumentRoot a `public/`.

2) Asegurate de que las carpetas sean escribibles por el servidor:
   - `/data` (base SQLite)
   - `/exports` (archivos generados)

3) Entrá a la web. En el primer acceso se crea la DB automáticamente.

## Uso
- Deudores: Alta/edición (PROVEEDORES)
- Importes: Cargar asistencias por deudor (IMPORTES)
- Tasa: Cargar por período (TASA)
- Generación: Elegís período (YYYYMM) y exportás los 3 archivos.

## Reglas BCRA implementadas (según Sección 59)
- Separador de campos: `;`
- Registros separados por CRLF
- Sin `;` al final de cada registro
- Codificación ANSI-1252 al exportar
- Importes en miles de pesos sin decimales (redondeo estándar)
- Excluye automáticamente deudores con deuda total < $25.000 (pesos)
